<?php
/*--------------------------------------------------------------------------------------------------
    AbstractPropertyQuantity.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Entities;

use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\Properties\SellingUnitQuantitiy\Quantitiy\Exceptions\ProductDoesntUsePropertyQuantityException;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\AbstractQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;

class AbstractPropertyQuantity extends AbstractQuantity implements ModifierQuantityInterface
{
    /**
     * @var ModifierIdentifierCollectionInterface
     */
    protected $collection;
    /**
     * @var bool
     */
    private $attributeStockCheck;
    /**
     * @var int
     */
    private $productStockCheckType;
    /**
     * @var bool
     */
    private $stockCheck;


    /**
     * AbstractPropertyQuantity constructor.
     *
     * @param float $quantity
     * @param string $measureUnit
     * @param bool $stockCheck
     * @param bool $attributeStockCheck
     * @param int $productStockCheckType
     *
     * @param ModifierIdentifierCollectionInterface $collection
     * @throws ProductDoesntUsePropertyQuantityException
     */
    public function __construct(
        float $quantity,
        string $measureUnit,
        bool $stockCheck,
        bool $attributeStockCheck,
        int $productStockCheckType,
        ModifierIdentifierCollectionInterface $collection
    ) {
        parent::__construct($quantity, $measureUnit);
        $this->stockCheck = $stockCheck;
        $this->attributeStockCheck = $attributeStockCheck;
        $this->productStockCheckType = $productStockCheckType;
        if (!$this->validateState()) {
            throw new ProductDoesntUsePropertyQuantityException('');
        }
        $this->collection = $collection;
    }


    /**
     * @return bool
     */
    protected function validateState(): bool
    {
        return (($this->productStockCheckType === 0 && $this->stockCheck && $this->attributeStockCheck)
                || ($this->productStockCheckType === 2));
    }

    /**
     * @inheritDoc
     */
    public function linkedModifiers(): ModifierIdentifierCollectionInterface
    {
        return $this->collection;
    }
}